import { defineStore } from 'pinia';
import api from '../api';

export const useSettingsStore = defineStore('settings', {
    state: () => ({
        company: {
            name: '',
            legal_name: '',
            email: '',
            phone: '',
            address: '',
            city: '',
            country: 'BH',
            logo: '',
        },
        regional: {
            currency: 'BHD',
            timezone: 'Asia/Bahrain',
            date_format: 'dd/MM/yyyy',
            fiscal_year_start: '1',
        },
        invoice: {
            prefix: 'INV-',
            next_number: 1,
            default_due_days: 30,
            default_notes: '',
            terms_conditions: '',
        },
        isLoading: false,
    }),

    actions: {
        async fetchCompanySettings() {
            const { data } = await api.get('/settings/company');
            this.company = data.data;
        },

        async updateCompanySettings(settings) {
            const { data } = await api.put('/settings/company', settings);
            this.company = data.data;
        },

        async fetchRegionalSettings() {
            const { data } = await api.get('/settings/regional');
            this.regional = data.data;
        },

        async updateRegionalSettings(settings) {
            const { data } = await api.put('/settings/regional', settings);
            this.regional = data.data;
        },

        async fetchInvoiceSettings() {
            const { data } = await api.get('/settings/invoice');
            this.invoice = data.data;
        },

        async updateInvoiceSettings(settings) {
            const { data } = await api.put('/settings/invoice', settings);
            this.invoice = data.data;
        },

        async fetchAll() {
            this.isLoading = true;
            try {
                await Promise.all([
                    this.fetchCompanySettings(),
                    this.fetchRegionalSettings(),
                    this.fetchInvoiceSettings(),
                ]);
            } finally {
                this.isLoading = false;
            }
        },
    },
});
